package gov.va.genisis2Test.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.junit.Test;

import gov.va.genisis2.dao.impl.CommentHistoryDao;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.service.impl.CommentHistoryService;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;
import gov.va.genisis2Test.util.Helper;

/**
 * The Class CommentHistoryServiceTest.
 *
 * @author Prasad Thummalapalli
 * 
 *          The Class CommentHistoryServiceTest.
 * 
 *          Description: Unit test class for CommentHistoryService - uses 
 *          mock implementation of CommentHistoryDao
 */

public class CommentHistoryServiceTest extends AbstractMockMvcTests {
	
	/**
	 * This method is used to TestCommentHistoryService.
	 * @exception Exception The exception.
	 */
	@Test
	public void testCommentHistoryService() throws Exception {
		CommentHistory commentHistory = Helper.getCommentHistory();

		CommentHistoryService commentHistoryService = new CommentHistoryService();
		assertNull(commentHistoryService.getCommentHistoryDao());
		
		// create mock object
		CommentHistoryDao mockCommentHistoryDao = getMockCommentHistoryDao();
		commentHistoryService.setCommentHistoryDao(mockCommentHistoryDao);

		// set behavior on a mock
		when(mockCommentHistoryDao.createCommentHistory(commentHistory)).thenReturn(1);
		int commentId = commentHistoryService.createCommentHistory(commentHistory);
		assertEquals(1, commentId);
		
		when(mockCommentHistoryDao.getCommentHistoryByCommentId(commentId)).thenReturn(commentHistory);
		CommentHistory commentHistory1 = commentHistoryService.getCommentHistoryByCommentId(commentId);
		assertNotNull(commentHistory1);
		
		when(mockCommentHistoryDao.updateCommentHistory(commentHistory)).thenReturn(2);
		commentId = commentHistoryService.updateCommentHistory(commentHistory);
		assertEquals(2, commentId);
		
		when(mockCommentHistoryDao.submitOrModify(commentHistory)).thenReturn(3);
		commentId = commentHistoryService.submitOrModify(commentHistory);
		assertEquals(3, commentId);
		
		List<CommentHistory> commentHistoryList = new ArrayList<>(Arrays.asList(commentHistory));
		when(mockCommentHistoryDao.getCommentHistories()).thenReturn(commentHistoryList);
		List<CommentHistory> list = commentHistoryService.getCommentHistories();
		assertNotNull(list);
		assertEquals(list, commentHistoryList);
		assertTrue(list.size() > 0);

		int requestId = 1;
		when(mockCommentHistoryDao.getCommentHistoriesByID(requestId)).thenReturn(commentHistory);
		CommentHistory commentHistoryone = commentHistoryService.getCommentHistoriesByID(requestId);
		assertNotNull(commentHistoryone);
		assertEquals(1, commentHistoryone.getCommentId());
		
		String uid = "datamanager1";
		List<CommentHistory> commentHistoryUList = new ArrayList<>(Arrays.asList(commentHistory));
		when(mockCommentHistoryDao.getCommentHistoriesByUID(uid)).thenReturn(commentHistoryUList);
		List<CommentHistory> list1 = commentHistoryService.getCommentHistoriesByUID(uid);
		assertNotNull(list1);
		assertEquals(list1, commentHistoryUList);
		assertTrue(list1.size() > 0);
		
		//TODO: verify method names on service and DAO 
		List<CommentHistory> commentHistoryRList = new ArrayList<>(Arrays.asList(commentHistory));
		when(mockCommentHistoryDao.getCommentHistoryById(requestId)).thenReturn(commentHistoryRList);
		List<CommentHistory> list2 = commentHistoryService.getCommentHistoryById(requestId);
		assertNotNull(list2);
		assertEquals(list2, commentHistoryRList);
		assertTrue(list2.size() > 0);
		
		String taskId = "taskId";
		List<CommentHistory> commentHistoryRsList = new ArrayList<>(Arrays.asList(commentHistory));
		when(mockCommentHistoryDao.getCommentHistoryByRequestIdStatusId(requestId, taskId)).thenReturn(commentHistoryRsList);
		List<CommentHistory> list3 = commentHistoryService.getCommentHistoryByRequestIdStatusId(requestId, taskId);
		assertNotNull(list3);
		assertEquals(list3, commentHistoryRsList);
		assertTrue(list3.size() > 0);
	}
}
